%------------------------------------------------------------------------------
% File     : NUM702^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 26b
% Version  : Especial.
% English  : moreis y x

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz26b [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.08 v7.4.0, 0.00 v6.2.0, 0.17 v6.1.0, 0.00 v5.3.0, 0.25 v5.2.0, 0.00 v4.0.0, 0.33 v3.7.0
% Syntax   : Number of formulae    :   13 (   0 unit;   9 type;   0 defn)
%            Number of atoms       :   26 (   0 equality;  10 variable)
%            Maximal formula depth :   11 (   4 average)
%            Number of connectives :   22 (   0   ~;   0   |;   0   &;  20   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   11 (  11   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   11 (   9   :;   0   =)
%            Number of variables   :    6 (   0 sgn;   4   !;   0   ?;   2   ^)
%                                         (   6   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(y,type,(
    y: nat )).

thf(some,type,(
    some: ( nat > $o ) > $o )).

thf(diffprop,type,(
    diffprop: nat > nat > nat > $o )).

thf(pl,type,(
    pl: nat > nat > nat )).

thf(n_1,type,(
    n_1: nat )).

thf(m,axiom,
    ( some
    @ ^ [Xu: nat] :
        ( diffprop @ ( pl @ y @ n_1 ) @ x @ Xu ) )).

thf(moreis,type,(
    moreis: nat > nat > $o )).

thf(lessis,type,(
    lessis: nat > nat > $o )).

thf(satz14,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( lessis @ Xx @ Xy )
     => ( moreis @ Xy @ Xx ) ) )).

thf(satz26,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( some
        @ ^ [Xv: nat] :
            ( diffprop @ ( pl @ Xx @ n_1 ) @ Xy @ Xv ) )
     => ( lessis @ Xy @ Xx ) ) )).

thf(satz26b,conjecture,
    ( moreis @ y @ x )).

%------------------------------------------------------------------------------
